!Object constantsFor: 'Geos Libraries'!

geosLIB70 'SYSTEM\socket'! !

!Object constantsFor: 'Geos vardata'!

!

!Object constantsFor: 'Geos messages'!

!

!Geos class methodsFor: 'library calls'!

SocketCreate: delivery
	"Socket pascal SocketCreate(SocketDeliveryType delivery) in socket.goh"
	^GEOS call: delivery with: #[70 0 34 1 1]!

SocketBind: s with: p with: flags
	"SocketError pascal SocketBind(Socket s, SocketPort p, SocketBindFlags flags) in socket.goh"
	^GEOS call: s with: p with: flags with: #[70 0 35 1 2 1 1]!

SocketBindInDomain: s with: p with: flags with: domain
	"SocketError pascal SocketBindInDomain(Socket s, SocketPort p, SocketBindFlags flags, TCHAR *domain) in socket.goh"
	^GEOS call: s with: p with: flags with: domain with: #[70 0 36 1 2 1 3 1]!

SocketListen: s with: qSize
	"SocketError pascal SocketListen(Socket s, int qSize) in socket.goh"
	^GEOS call: s with: qSize with: #[70 0 37 1 4 1]!

SocketAddLoadOnMsg: p with: slt with: disk with: path
	"SocketError pascal SocketAddLoadOnMsg(SocketPort p, SocketLoadType slt, word disk, TCHAR *path) in socket.goh"
	^GEOS call: p with: slt with: disk with: path with: #[70 0 38 2 1 1 3 1]!

SocketAddLoadOnMsgInDomain: p with: slt with: disk with: path with: domain
	"SocketError pascal SocketAddLoadOnMsgInDomain(SocketPort p, SocketLoadType slt, word disk, TCHAR *path, TCHAR *domain) in socket.goh"
	^GEOS call: p with: slt with: disk with: path with: domain with: #[70 0 39 2 1 1 3 3 1]!

SocketRemoveLoadOnMsg: p
	"SocketError pascal SocketRemoveLoadOnMsg(SocketPort p) in socket.goh"
	^GEOS call: p with: #[70 0 40 2 1]!

SocketRemoveLoadOnMsgInDomain: p with: domain
	"SocketError pascal SocketRemoveLoadOnMsgInDomain(SocketPort p, TCHAR *domain) in socket.goh"
	^GEOS call: p with: domain with: #[70 0 41 2 3 1]!

SocketInterrupt: s
	"SocketError pascal SocketInterrupt(Socket s) in socket.goh"
	^GEOS call: s with: #[70 0 61 1 1]!

SocketInterruptResolve: domain with: address with: addrSize
	"SocketError pascal SocketInterruptResolve(TCHAR *domain, byte *address, int addrSize) in socket.goh"
	^GEOS call: domain with: address with: addrSize with: #[70 0 67 3 3 4 1]!

SocketConnect: s with: addr with: timeout
	"SocketError pascal SocketConnect(Socket s, SocketAddress *addr, int timeout) in socket.goh"
	^GEOS call: s with: addr with: timeout with: #[70 0 42 1 3 4 1]!

SocketSetIntSocketOption: skt with: opt with: newval
	"void pascal SocketSetIntSocketOption(Socket skt, SocketOption opt, int newval) in socket.goh"
	^GEOS call: skt with: opt with: newval with: #[70 0 63 1 1 4 0]!

SocketGetIntSocketOption: skt with: opt
	"int pascal SocketGetIntSocketOption(Socket skt, SocketOption opt) in socket.goh"
	^GEOS call: skt with: opt with: #[70 0 62 1 1 4]!

SocketCheckListen: p with: domain with: bufsize
	"int pascal SocketCheckListen(SocketPort p, TCHAR *domain, int bufsize) in socket.goh"
	^GEOS call: p with: domain with: bufsize with: #[70 0 43 2 3 4 4]!

SocketAccept: s with: timeout
	"Socket pascal SocketAccept(Socket s, int timeout) in socket.goh"
	^GEOS call: s with: timeout with: #[70 0 44 1 4 1]!

SocketGetPeerName: s with: addr
	"SocketError pascal SocketGetPeerName(Socket s, SocketAddress *addr) in socket.goh"
	^GEOS call: s with: addr with: #[70 0 45 1 3 1]!

SocketGetSocketName: s with: addr
	"SocketError pascal SocketGetSocketName(Socket s, SocketAddress *addr) in socket.goh"
	^GEOS call: s with: addr with: #[70 0 46 1 3 1]!

SocketSend: s with: buffer with: bufSize with: flags with: addr
	"SocketError pascal SocketSend(Socket s, void *buffer, int bufSize, SocketSendFlags flags, SocketAddress *addr) in socket.goh"
	^GEOS call: s with: buffer with: bufSize with: flags with: addr with: #[70 0 47 1 3 4 1 3 1]!

SocketRecv: s with: buffer with: bufSize with: timeout with: flags with: addr
	"int pascal SocketRecv(Socket s, void *buffer, int bufSize, int timeout, SocketRecvFlags flags, SocketAddress *addr) in socket.goh"
	^GEOS call: s with: buffer with: bufSize with: timeout with: flags with: addr with: #[70 0 48 1 3 4 4 1 3 4]!

SocketCloseSend: s
	"SocketError pascal SocketCloseSend(Socket s) in socket.goh"
	^GEOS call: s with: #[70 0 49 1 1]!

SocketClose: s
	"SocketError pascal SocketClose(Socket s) in socket.goh"
	^GEOS call: s with: #[70 0 50 1 1]!

SocketReset: s
	"SocketError pascal SocketReset(Socket s) in socket.goh"
	^GEOS call: s with: #[70 0 71 1 1]!

SocketCloseDomainMedium: domain with: mau with: force
	"int pascal SocketCloseDomainMedium(char *domain, MediumAndUnit *mau, Boolean force) in socket.goh"
	^GEOS call: domain with: mau with: force with: #[70 0 51 3 3 4 4]!

SocketOpenDomainMedium: addr with: timeout
	"SocketError pascal SocketOpenDomainMedium(SocketAddress *addr, int timeout) in socket.goh"
	^GEOS call: addr with: timeout with: #[70 0 66 3 4 1]!

SocketCheckReady: requests with: numRequests with: timeout
	"int pascal SocketCheckReady(SocketCheckRequest *requests, int numRequests, int timeout) in socket.goh"
	^GEOS call: requests with: numRequests with: timeout with: #[70 0 52 3 4 4 4]!

SocketGetDomains: domainList
	"ChunkHandle pascal SocketGetDomains(optr domainList) in socket.goh"
	^GEOS call: domainList with: #[70 0 53 2 1]!

SocketGetDomainMedia: domain with: mediaList
	"ChunkHandle pascal SocketGetDomainMedia(char *domain, optr mediaList) in socket.goh"
	^GEOS call: domain with: mediaList with: #[70 0 54 3 2 1]!

SocketGetAddressMedium: sa with: mau
	"SocketError pascal SocketGetAddressMedium(SocketAddress *sa, MediumAndUnit *mau) in socket.goh"
	^GEOS call: sa with: mau with: #[70 0 55 3 3 1]!

SocketCheckMediumConnection: domain with: buffer with: bufsize with: mau
	"SocketError pascal SocketCheckMediumConnection(char *domain, byte *buffer, int *bufsize, MediumAndUnit *mau) in socket.goh"
	^GEOS call: domain with: buffer with: bufsize with: mau with: #[70 0 60 3 3 3 3 1]!

SocketGetMediumAddress: domain with: buffer with: bufsize with: mau
	"SocketError pascal SocketGetMediumAddress(char *domain, byte *buffer, int *bufsize, MediumAndUnit *mau) in socket.goh"
	^GEOS call: domain with: buffer with: bufsize with: mau with: #[70 0 69 3 3 3 3 1]!

SocketGetAddressController: domain
	"ClassStruct * pascal SocketGetAddressController(char *domain) in socket.goh"
	^GEOS call: domain with: #[70 0 56 3 3]!

SocketGetAddressSize: domain
	"int pascal SocketGetAddressSize(char *domain) in socket.goh"
	^GEOS call: domain with: #[70 0 58 3 4]!

SocketResolve: domainName with: rawAddr with: addrSize with: result with: resultBuffSize
	"int pascal SocketResolve( char *domainName, byte *rawAddr, int addrSize, byte *result, int resultBuffSize ) in socket.goh"
	^GEOS call: domainName with: rawAddr with: addrSize with: result with: resultBuffSize with: #[70 0 57 3 3 4 3 4 4]!

SocketCreateResolvedAddress: domainName with: rawAddr with: addrSize
	"MemHandle pascal SocketCreateResolvedAddress(const char *domainName, byte *rawAddr, int addrSize) in socket.goh"
	^GEOS call: domainName with: rawAddr with: addrSize with: #[70 0 59 3 3 4 1]!

SocketSetMediumBusy: domain with: mau with: busy
	"Boolean pascal SocketSetMediumBusy(char *domain, MediumAndUnit *mau, Boolean busy) in socket.goh"
	^GEOS call: domain with: mau with: busy with: #[70 0 73 3 3 4 4]!

!

